<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Paiement extends Eloquent {

	protected $table = 'paiements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_location', 'date', 'etat_paiement', 'local_code_paiement', 'online_code_paiement', 'statut');
	protected $visible = array('slug', 'id_location', 'date', 'etat_paiement', 'local_code_paiement', 'online_code_paiement', 'statut');

	public function location()
	{
		return $this->belongsTo('App\Location', 'id_location');
	}

}