<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PeriodePaiement extends Eloquent {

	protected $table = 'periodesPaiements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'libelle');
	protected $visible = array('slug', 'libelle');

	public function location()
	{
		return $this->hasMany('App\Location', 'id_periodePaiement');
	}

	public function transaction()
	{
		return $this->hasMany('App\Transaction', 'id_frequence');
	}

}