<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TypeBien extends Eloquent {

	protected $table = 'typeBiens';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'libelle');
	protected $visible = array('slug', 'libelle');

	public function bien()
	{
		return $this->hasMany('App\Bien', 'id_typeBien');
	}

}