<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 15)->unique();
			$table->string('email', 50)->unique();
			$table->string('password', 60);
			$table->string('password_temp', 60);
			$table->boolean('is_admin');
			$table->string('code', 60);
			$table->integer('active');
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}