<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 191)->nullable();
			$table->string('email', 191)->nullable();
			$table->string('mobile', 191)->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->date('birthday')->nullable();
			$table->enum('type', array('user', 'driver'))->nullable();
			$table->string('password', 191)->nullable();
			$table->string('confirm_code', 191)->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->integer('wallet')->unsigned()->nullable();
			$table->enum('notification', array('true', 'false'))->nullable();
			$table->string('image', 191)->nullable();
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->string('id_image_fornt', 191)->nullable();
			$table->string('id_image_back', 191)->nullable();
			$table->string('license_image_front', 191)->nullable();
			$table->string('license_image_back', 191)->nullable();
			$table->string('car_image_front', 191)->nullable();
			$table->string('car_image_back', 191)->nullable();
			$table->integer('car_type_id')->unsigned()->nullable();
			$table->string('car_number', 191)->nullable();
			$table->string('car_color', 191)->nullable();
			$table->string('personal_license_front', 191)->nullable();
			$table->string('personal_license_back', 191)->nullable();
			$table->integer('car_model_id')->unsigned();
			$table->integer('year_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}