<?php

namespace Models;

class Rate extends Eloquent {

	protected $table = 'rates';
	public $timestamps = true;
	protected $fillable = array('user_id', 'driver_id', 'rate', 'reason_id');

	public function users()
	{
		return $this->belongsTo('Models\User', 'user_id');
	}

	public function drivers()
	{
		return $this->belongsTo('Models\User', 'user_id');
	}

	public function reason()
	{
		return $this->belongsTo('Models\Reason', 'reason_id');
	}

}