<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComplaintsTable extends Migration {

	public function up()
	{
		Schema::create('complaints', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('reason_id')->unsigned()->nullable();
			$table->text('body')->nullable();
			$table->enum('status', array('waiting', 'in_progress_solved'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('complaints');
	}
}