<?php

namespace Models;

class CarModel extends Eloquent {

	protected $table = 'car_models';
	public $timestamps = true;
	protected $fillable = array('name', 'mark_id');

	public function mark()
	{
		return $this->belongsTo('Models\Mark', 'mark_id');
	}

	public function years()
	{
		return $this->hasMany('Models\Year', 'model_id');
	}

	public function users()
	{
		return $this->hasMany('Models\User', 'car_model_id');
	}

}