<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('User', function(Blueprint $table) {
			$table->foreign('category')->references('id')->on('Category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Relationship', function(Blueprint $table) {
			$table->foreign('followe_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Shared', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('Post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Shared', function(Blueprint $table) {
			$table->foreign('shared_with_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Group', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Group_Post', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('Group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Group_Post', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Message', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Message', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('User', function(Blueprint $table) {
			$table->dropForeign('User_category_foreign');
		});
		Schema::table('Relationship', function(Blueprint $table) {
			$table->dropForeign('Relationship_followe_id_foreign');
		});
		Schema::table('Shared', function(Blueprint $table) {
			$table->dropForeign('Shared_post_id_foreign');
		});
		Schema::table('Shared', function(Blueprint $table) {
			$table->dropForeign('Shared_shared_with_id_foreign');
		});
		Schema::table('Group', function(Blueprint $table) {
			$table->dropForeign('Group_owner_id_foreign');
		});
		Schema::table('Group_Post', function(Blueprint $table) {
			$table->dropForeign('Group_Post_group_id_foreign');
		});
		Schema::table('Group_Post', function(Blueprint $table) {
			$table->dropForeign('Group_Post_owner_id_foreign');
		});
		Schema::table('Message', function(Blueprint $table) {
			$table->dropForeign('Message_sender_id_foreign');
		});
		Schema::table('Message', function(Blueprint $table) {
			$table->dropForeign('Message_receiver_id_foreign');
		});
	}
}