<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('channels', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('app_user', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('channels', function(Blueprint $table) {
			$table->dropForeign('channels_app_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_channel_id_foreign');
		});
		Schema::table('app_user', function(Blueprint $table) {
			$table->dropForeign('app_user_user_id_foreign');
		});
		Schema::table('app_user', function(Blueprint $table) {
			$table->dropForeign('app_user_app_id_foreign');
		});
	}
}