<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('slug');
			$table->string('password');
			$table->string('confirmation_code');
			$table->tinyInteger('confirmed');
			$table->string('photo_url');
			$table->integer('wepay_id');
			$table->integer('role_id')->unsigned();
			$table->string('wepay_token');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}