<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('step_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('workflow_id')->unsigned();
			$table->string('message');
			$table->enum('type', array('email', 'SMS', 'in_app'));
			$table->boolean('is_read');
			$table->date('delivery_time');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}