<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('username', 'password', 'role');
    protected $visible = array('username', 'password', 'role');

    public function categories()
    {
        return $this->belongsToMany('App\Category')->withPivot('points')->withTimestamps();
    }

    public function points()
    {
        return $this->hasMany('App\Point');
    }

}