<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_service_tag', function(Blueprint $table) {
			$table->foreign('service_tag_id')->references('id')->on('service_tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_service_tag', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('request_service', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('request_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reacts', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reacts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_user', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->foreign('friend_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('friend_requests', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('friend_requests', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('user_service_tag', function(Blueprint $table) {
			$table->dropForeign('user_service_tag_service_tag_id_foreign');
		});
		Schema::table('user_service_tag', function(Blueprint $table) {
			$table->dropForeign('user_service_tag_user_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_category_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_user_id_foreign');
		});
		Schema::table('request_service', function(Blueprint $table) {
			$table->dropForeign('request_service_user_id_foreign');
		});
		Schema::table('request_service', function(Blueprint $table) {
			$table->dropForeign('request_service_service_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_post_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('reacts', function(Blueprint $table) {
			$table->dropForeign('reacts_post_id_foreign');
		});
		Schema::table('reacts', function(Blueprint $table) {
			$table->dropForeign('reacts_user_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_user_id_foreign');
		});
		Schema::table('event_user', function(Blueprint $table) {
			$table->dropForeign('event_user_event_id_foreign');
		});
		Schema::table('event_user', function(Blueprint $table) {
			$table->dropForeign('event_user_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->dropForeign('friendships_friend_id_foreign');
		});
		Schema::table('friend_requests', function(Blueprint $table) {
			$table->dropForeign('friend_requests_sender_id_foreign');
		});
		Schema::table('friend_requests', function(Blueprint $table) {
			$table->dropForeign('friend_requests_receiver_id_foreign');
		});
	}
}