<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Employee extends Eloquent {

	protected $table = 'employee';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'middle_name', 'last_name', 'sex', 'birth_date', 'join_at', 'position');

	public function getTeacher()
	{
		return $this->hasOne('App\Model\Teacher');
	}

}