<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductDescriptionTable extends Migration {

	public function up()
	{
		Schema::create('product_description', function(Blueprint $table) {
			$table->increments('id', true);
			$table->bigInteger('language_id');
			$table->string('name', 255)->index();
			$table->text('description');
			$table->string('meta_title', 255);
			$table->string('meta_description', 255);
			$table->string('meta_keyword', 255);
			$table->text('tag');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_description');
	}
}