<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('model', 64);
			$table->string('sku', 64)->nullable();
			$table->string('upc', 64)->nullable();
			$table->string('ean', 64)->nullable();
			$table->string('jan', 64)->nullable();
			$table->string('isbn', 64)->nullable();
			$table->string('mpn', 64)->nullable();
			$table->string('location', 128)->nullable();
			$table->integer('quantity')->default('0');
			$table->bigInteger('minimum')->default('1');
			$table->tinyInteger('subtract')->default('1');
			$table->bigInteger('stock_status_id');
			$table->tinyInteger('shipping')->default('1');
			$table->date('date_available');
			$table->decimal('length', 15,4)->default('0.00000000');
			$table->decimal('width', 15,4)->default('0.00000000');
			$table->decimal('height', 15,4)->default('0.00000000');
			$table->bigInteger('lenght_class_id')->default('0');
			$table->decimal('weight', 15,4)->default('0.00000000');
			$table->bigInteger('weight_class_id')->default('0');
			$table->tinyInteger('status')->default('0');
			$table->bigInteger('sort_order')->default('0');
			$table->bigInteger('manufacturer_id');
			$table->string('image', 255)->nullable()->default('NULL');
			$table->decimal('price', 15,4)->default('0.0000');
			$table->integer('points')->default('0');
			$table->bigInteger('tax_class_id');
			$table->smallInteger('viewed')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}