<?php

namespace product_description;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product_description extends Model 
{

    protected $table = 'product_description';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('language_id', 'name', 'description', 'meta_title', 'meta_description', 'meta_keyword', 'tag');

    public function product()
    {
        return $this->belongsTo('Product');
    }

}