<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductOptionTable extends Migration {

	public function up()
	{
		Schema::create('product_option', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id')->unsigned();
			$table->bigInteger('option_id')->unsigned();
			$table->text('value');
			$table->tinyInteger('required');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_option');
	}
}