<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_description', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_image', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_description', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->foreign('product_option_id')->references('id')->on('product_option')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->foreign('option_value_id')->references('id')->on('option_value')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_filter', function(Blueprint $table) {
			$table->foreign('filter_id')->references('id')->on('filter')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attribute')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('length_class_desc', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('weight_class_desc', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('filter', function(Blueprint $table) {
			$table->foreign('filter_group_id')->references('id')->on('filter_group')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('filter_description', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('filter_description', function(Blueprint $table) {
			$table->foreign('filter_group_id')->references('id')->on('filter_group')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('filter_group_desc', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute', function(Blueprint $table) {
			$table->foreign('attribute_group_id')->references('id')->on('attribute_group')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute_description', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute_group_desc', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('option_description', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('option_value', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('option_value_desc', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('option_value_desc', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('product_description', function(Blueprint $table) {
			$table->dropForeign('product_description_language_id_foreign');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->dropForeign('product_discount_product_id_foreign');
		});
		Schema::table('product_image', function(Blueprint $table) {
			$table->dropForeign('product_image_product_id_foreign');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->dropForeign('product_category_category_id_foreign');
		});
		Schema::table('category_description', function(Blueprint $table) {
			$table->dropForeign('category_description_language_id_foreign');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->dropForeign('product_option_product_id_foreign');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->dropForeign('product_option_option_id_foreign');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->dropForeign('product_option_value_product_option_id_foreign');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->dropForeign('product_option_value_product_id_foreign');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->dropForeign('product_option_value_option_id_foreign');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->dropForeign('product_option_value_option_value_id_foreign');
		});
		Schema::table('product_filter', function(Blueprint $table) {
			$table->dropForeign('product_filter_filter_id_foreign');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->dropForeign('product_attribute_attribute_id_foreign');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->dropForeign('product_attribute_language_id_foreign');
		});
		Schema::table('length_class_desc', function(Blueprint $table) {
			$table->dropForeign('length_class_desc_language_id_foreign');
		});
		Schema::table('weight_class_desc', function(Blueprint $table) {
			$table->dropForeign('weight_class_desc_language_id_foreign');
		});
		Schema::table('filter', function(Blueprint $table) {
			$table->dropForeign('filter_filter_group_id_foreign');
		});
		Schema::table('filter_description', function(Blueprint $table) {
			$table->dropForeign('filter_description_language_id_foreign');
		});
		Schema::table('filter_description', function(Blueprint $table) {
			$table->dropForeign('filter_description_filter_group_id_foreign');
		});
		Schema::table('filter_group_desc', function(Blueprint $table) {
			$table->dropForeign('filter_group_desc_language_id_foreign');
		});
		Schema::table('attribute', function(Blueprint $table) {
			$table->dropForeign('attribute_attribute_group_id_foreign');
		});
		Schema::table('attribute_description', function(Blueprint $table) {
			$table->dropForeign('attribute_description_language_id_foreign');
		});
		Schema::table('attribute_group_desc', function(Blueprint $table) {
			$table->dropForeign('attribute_group_desc_language_id_foreign');
		});
		Schema::table('option_description', function(Blueprint $table) {
			$table->dropForeign('option_description_language_id_foreign');
		});
		Schema::table('option_value', function(Blueprint $table) {
			$table->dropForeign('option_value_option_id_foreign');
		});
		Schema::table('option_value_desc', function(Blueprint $table) {
			$table->dropForeign('option_value_desc_language_id_foreign');
		});
		Schema::table('option_value_desc', function(Blueprint $table) {
			$table->dropForeign('option_value_desc_option_id_foreign');
		});
	}
}