<?php

namespace angkasapos;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DebtBilling extends Model 
{

    protected $table = 'debt_billing';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function debts()
    {
        return $this->hasOne('Debts', 'id_debt');
    }

    public function customer()
    {
        return $this->hasOne('Customers', 'id_customer');
    }

    public function tenant()
    {
        return $this->hasOne('Tenant', 'id_tenant');
    }

}