<?php

namespace angkasapos;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Selling extends Model 
{

    protected $table = 'selling';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function paymentType()
    {
        return $this->hasOne('PaymentTypes', 'id_paytype');
    }

    public function sellingItems()
    {
        return $this->hasMany('SellingItems', 'id_sellingitem');
    }

    public function discount()
    {
        return $this->hasOne('Discount', 'id_discount');
    }

    public function tenant()
    {
        return $this->hasOne('Tenant', 'id_tenant');
    }

}