<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePapersTable extends Migration {

	public function up()
	{
		Schema::create('papers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191)->nullable();
			$table->string('year', 20)->nullable();
			$table->integer('journal_id')->unsigned()->nullable();
			$table->string('pdf_url', 191)->nullable();
			$table->string('no_of_agents', 191)->nullable();
			$table->string('fps', 191)->nullable();
			$table->string('sim_time', 191)->nullable();
			$table->string('tool_name', 191)->nullable();
			$table->string('simulation_tool', 191)->nullable();
			$table->string('application_name', 191)->nullable();
			$table->string('application_mode', 191)->nullable();
			$table->string('application_type', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('papers');
	}
}