<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseCoachesTable extends Migration {

	public function up()
	{
		Schema::create('course_coaches', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('place');
			$table->date('start_date');
			$table->date('finish_date');
			$table->time('start_time');
			$table->time('finish_time');
			$table->date('register_date');
			$table->integer('amount');
			$table->text('detail');
			$table->text('qualification');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('course_coaches');
	}
}