<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name_th');
			$table->string('last_name_th');
			$table->string('first_name_en');
			$table->string('last_name_en');
			$table->string('id_card');
			$table->enum('gender', array('m', 'f'));
			$table->date('birthdate');
			$table->string('nick_name');
			$table->string('religion');
			$table->string('race');
			$table->string('nationality');
			$table->string('phone');
			$table->string('email');
			$table->string('club');
			$table->string('address');
			$table->integer('provice');
			$table->integer('district');
			$table->integer('subdistrict');
			$table->integer('zipcode');
			$table->enum('position', array('GK', 'DF', 'CM', 'FW'));
			$table->string('number');
			$table->integer('height');
			$table->integer('weight');
			$table->enum('dominant_foot', array('left', 'right', 'both'));
			$table->string('file_photo');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}