<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Course_player extends Eloquent {

	protected $table = 'course_players';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function test_topic()
	{
		return $this->hasMany('Test_topic', 'course_id');
	}

	public function player_register()
	{
		return $this->hasMany('Course_player_register', 'course_id');
	}

	public function testing()
	{
		return $this->hasMany('Player_testing', 'course_id');
	}

}