<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Player extends Eloquent {

	protected $table = 'players';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function player_owner()
	{
		return $this->hasMany('Player_owners', 'player_id');
	}

	public function player_register()
	{
		return $this->hasMany('Course_player_register', 'player_id');
	}

	public function testing()
	{
		return $this->hasMany('Player_testing', 'player_id');
	}

}