<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50)->unique();
			$table->string('nationality', 50)->unique();
			$table->string('code', 4)->unique();
			$table->string('country_code', 5)->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}