<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name', 100);
			$table->string('email', 150)->unique()->nullable();
			$table->string('country_code', 5);
			$table->string('phone', 20)->unique();
			$table->string('password', 255);
			$table->boolean('is_smoking');
			$table->boolean('active')->default(false);
			$table->decimal('latitude', 9,6)->nullable();
			$table->decimal('longitude', 9,6)->nullable();
			$table->datetime('birthday');
			$table->integer('nationality_id')->unsigned()->nullable();
			$table->string('image', 255)->nullable();
			$table->string('fcm_token')->nullable();
			$table->integer('language_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}