<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJugadoresTable extends Migration {

	public function up()
	{
		Schema::create('jugadores', function(Blueprint $table) {
			$table->string('dni')->primary();
			$table->timestamps();
			$table->string('apellido')->index();
			$table->string('nombre')->index();
			$table->date('nacimiento');
			$table->string('calle');
			$table->string('numero');
			$table->string('piso')->nullable();
			$table->string('depto')->nullable();
			$table->string('ecalles')->nullable();
			$table->string('codpos')->nullable();
			$table->string('localidad')->nullable();
			$table->string('barrio')->nullable();
			$table->string('telefono')->nullable();
			$table->string('telefono1')->nullable();
			$table->string('telefono2')->nullable();
			$table->date('falta');
			$table->date('fliquidacion');
			$table->date('fbaja');
			$table->integer('obra_social_id')->unsigned()->nullable();
			$table->integer('categoria_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('jugadores');
	}
}