<?php

namespace App\Models;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;
	protected $fillable = array('reference', 'store_id', 'command_id', 'total', 'store_stripe_id', 'store_paypal_id');
	protected $visible = array('reference', 'store_id', 'command_id', 'total', 'store_stripe_id', 'store_paypal_id');

	public function stripes()
	{
		return $this->belongsTo('App\Models\Stripe');
	}

	public function paypals()
	{
		return $this->belongsTo('App\Models\Paypal');
	}

}