<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExamsTable extends Migration {

	public function up()
	{
		Schema::create('exams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('physical_exam_overrides_id');
			$table->integer('exam_type_index');
			$table->integer('points');
			$table->integer('tool_type_index');
			$table->string('inspection_result', 256);
			$table->string('auscultation_result', 256);
			$table->text('palpation_result');
			$table->string('percution_animation', 256);
			$table->string('percution_audio', 256);
		});
	}

	public function down()
	{
		Schema::drop('exams');
	}
}