<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateColumnReelTable extends Migration {

	public function up()
	{
		Schema::create('column_reel', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('column_id')->unsigned();
			$table->integer('reel_id')->unsigned();
			$table->tinyInteger('column_position')->unsigned();
			$table->integer('depends_on')->unsigned()->nullable();
			$table->boolean('is_sync')->default(0);
			$table->boolean('is_active');
			$table->boolean('is_shareable')->default(1);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('column_reel');
	}
}