<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateListsTable extends Migration {

	public function up()
	{
		Schema::create('lists', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('slug')->nullable();
			$table->integer('depends_on')->unsigned()->nullable();
			$table->boolean('is_sync');
			$table->boolean('is_active');
			$table->boolean('is_shareable');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lists');
	}
}