<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateObjectTable extends Migration {

	public function up()
	{
		Schema::create('object', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('reel_id')->unsigned();
			$table->integer('object_type_id')->unsigned();
			$table->string('title')->nullable();
			$table->string('url')->nullable();
			$table->string('thumbnail_url')->nullable();
			$table->string('provider_url')->nullable();
			$table->string('provider_name')->nullable();
			$table->string('author_name')->nullable();
			$table->string('author_url')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('object');
	}
}