<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Color extends Model 
{

    protected $table = 'colors';
    public $timestamps = true;
    protected $fillable = array('name', 'en_name', 'product_id');

    public function getProduct()
    {
        return $this->belongsTo('Products', 'product_id');
    }

    public function getOrders()
    {
        return $this->hasMany('Order');
    }

}