<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('ar_name');
			$table->string('en_name', 255);
			$table->string('ar_descr', 255);
			$table->string('en_descr', 255);
			$table->string('discount_value', 255);
			$table->integer('type');
			$table->string('price', 255);
			$table->integer('qty');
			$table->integer('category_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}