<?php

namespace App;

class Store extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;
	protected $fillable = array('user_id', 'product_id', 'name', 'en_name', 'logo', 'descr', 'en_descr', 'category_id', 'lng', 'lat');

	public function getUser()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function getProduct()
	{
		return $this->belongsTo('Products', 'product_id');
	}

	public function getCategory()
	{
		return $this->belongsTo('Categories', 'category_id');
	}

	public function getStores()
	{
		return $this->hasMany('Store');
	}

	public function getOffers()
	{
		return $this->hasMany('Offers');
	}

	public function getRatings()
	{
		return $this->hasMany('Ratings');
	}

}