<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('exams', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('options', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exam_questions', function(Blueprint $table) {
			$table->foreign('exam_id')->references('id')->on('exams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exam_questions', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_questions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_questions', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('options')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('exam_questions_id')->references('id')->on('exam_questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('exams', function(Blueprint $table) {
			$table->dropForeign('exams_subject_id_foreign');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->dropForeign('exams_user_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_subject_id_foreign');
		});
		Schema::table('options', function(Blueprint $table) {
			$table->dropForeign('options_question_id_foreign');
		});
		Schema::table('exam_questions', function(Blueprint $table) {
			$table->dropForeign('exam_questions_exam_id_foreign');
		});
		Schema::table('exam_questions', function(Blueprint $table) {
			$table->dropForeign('exam_questions_question_id_foreign');
		});
		Schema::table('user_questions', function(Blueprint $table) {
			$table->dropForeign('user_questions_user_id_foreign');
		});
		Schema::table('user_questions', function(Blueprint $table) {
			$table->dropForeign('user_questions_question_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_user_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_option_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_exam_questions_id_foreign');
		});
	}
}