<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AssignTo extends Eloquent {

	protected $table = 'assign_to';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('task_id', 'assign_id');

	public function task()
	{
		return $this->belongsTo('Task', 'task_id');
	}

	public function assign()
	{
		return $this->belongsTo('User', 'assign_id');
	}

}