<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProceduresTable extends Migration {

	public function up()
	{
		Schema::create('procedures', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tenant_id')->unsigned();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned();
			$table->bigInteger('status_id')->unsigned()->nullable();
			$table->string('ref_id')->nullable()->index();
			$table->json('payload')->nullable();
			$table->string('type');
			$table->string('submitted_at');
			$table->string('returned_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('procedures');
	}
}