<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenantsTable extends Migration {

	public function up()
	{
		Schema::create('tenants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('ref_id')->unique()->nullable();
			$table->string('title');
			$table->string('portal_domain');
			$table->boolean('portal_enabled');
			$table->string('street');
			$table->string('postalcode');
			$table->string('city');
			$table->string('phone');
			$table->string('fax');
			$table->string('website');
			$table->string('email_general');
			$table->string('email_service');
			$table->boolean('enabled_connection_water');
			$table->boolean('enabled_connection_water_disposal');
			$table->boolean('enabled_discharger');
			$table->string('enabled_downpayment');
			$table->string('config_advancepayment_offset_days');
			$table->string('config_advancepayment_max_percent');
			$table->string('config_imprint_url');
			$table->string('config_privacy_statement_url');
			$table->string('config_privacy_statement');
			$table->string('config_mail_signature');
			$table->string('config_mail_sender_name');
			$table->string('config_mail_sender_email');
			$table->string('config_mail_sender_replyto');
			$table->string('config_mail_cc');
			$table->string('config_mail_bcc');
			$table->string('config_mail_server');
			$table->string('config_mail_username');
			$table->string('config_mail_password');
			$table->string('config_storage_tenant_folder');
			$table->json('config_custom_frontend');
			$table->json('config_custom_theme')->nullable();
			$table->json('config_custom_system')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tenants');
	}
}