<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerUserTable extends Migration {

	public function up()
	{
		Schema::create('customer_user', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('customer_id');
			$table->string('approval_type');
			$table->string('approval_token');
			$table->timestamp('approved_at');
			$table->timestamp('invited_at');
			$table->string('invited_by');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_user');
	}
}