<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable()->index();
			$table->string('name')->nullable()->index();
			$table->string('slug')->unique();
			$table->text('excerpt')->nullable();
			$table->text('content')->nullable();
			$table->string('meta_title')->nullable();
			$table->string('meta_description')->nullable();
			$table->string('meta_keywords')->nullable();
			$table->string('status')->index()->default('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}