<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentCoachesTable extends Migration {

	public function up()
	{
		Schema::create('tournament_coaches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('season_id')->primary()->unsigned()->index();
			$table->integer('tournament_id')->unsigned()->index();
			$table->integer('tournament_season_id')->unsigned()->index();
			$table->integer('coach_id')->primary()->unsigned()->index();
			$table->integer('games')->nullable();
			$table->integer('wins')->unsigned()->nullable();
			$table->integer('draws')->nullable();
			$table->integer('loses')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tournament_coaches');
	}
}