<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentPassesTable extends Migration {

	public function up()
	{
		Schema::create('tournament_passes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('match_id')->primary()->unsigned()->index();
			$table->integer('player_id')->primary()->unsigned()->index();
			$table->smallInteger('time')->nullable();
			$table->smallInteger('overtime')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tournament_passes');
	}
}