<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentPlayersTable extends Migration {

	public function up()
	{
		Schema::create('tournament_players', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('season_id')->primary()->unsigned()->index();
			$table->integer('tournament_id')->primary()->unsigned()->index();
			$table->integer('tournament_season_id')->unsigned();
			$table->integer('team_id')->primary()->unsigned()->index();
			$table->integer('player_id')->primary()->unsigned()->index();
			$table->smallInteger('player_number')->nullable();
			$table->integer('amplua_id')->unsigned()->index();
			$table->integer('total_minutes')->nullable();
			$table->integer('total_games')->nullable();
			$table->integer('start_games')->nullable();
			$table->integer('out_games')->nullable();
			$table->integer('subst_games')->nullable();
			$table->integer('noplay_games')->nullable();
			$table->integer('scored_goals')->nullable();
			$table->integer('penalty_goals')->nullable();
			$table->integer('nopenalty_goals')->nullable();
			$table->integer('missed_goals')->nullable();
			$table->integer('passes')->nullable();
			$table->integer('yc')->nullable();
			$table->integer('2yc')->nullable();
			$table->integer('rc')->nullable();
			$table->string('type');
			$table->timestamp('timestamps');
		});
	}

	public function down()
	{
		Schema::drop('tournament_players');
	}
}