<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentTablesTable extends Migration {

	public function up()
	{
		Schema::create('tournament_tables', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('season_id')->unsigned()->index();
			$table->integer('tournament_id')->unsigned()->index();
			$table->integer('tournament_season_id')->primary()->unsigned()->index();
			$table->integer('tournament_round_id')->unsigned()->nullable()->index();
			$table->integer('tournament_group_id')->unsigned()->nullable()->index();
			$table->integer('team_id')->primary()->unsigned()->index();
			$table->smallInteger('games')->nullable();
			$table->smallInteger('wins')->nullable();
			$table->smallInteger('draws')->nullable();
			$table->smallInteger('loses')->nullable();
			$table->smallInteger('scored_goals')->nullable();
			$table->smallInteger('missed_goals')->nullable();
			$table->smallInteger('points');
			$table->integer('type')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tournament_tables');
	}
}