<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Player extends Model 
{

    protected $table = 'players';
    public $timestamps = false;
    protected $fillable = array('name', 'slug', 'about', 'career', 'img', 'birthday', 'growth', 'weight', 'instagram', 'wikipedia', 'facebook', 'twitter', 'site');

    public function nationalities()
    {
        return $this->morphToMany('Country', 'nationality');
    }

    public function galleries()
    {
        return $this->morphMany('User', 'entity');
    }

    public function statistic()
    {
        return $this->hasOne('PlayerStatistic');
    }

}