<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('barang', function(Blueprint $table) {
			$table->foreign('satuan_id')->references('id')->on('satuan')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('penjualan', function(Blueprint $table) {
			$table->foreign('barang_id')->references('id')->on('barang')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('penjualan', function(Blueprint $table) {
			$table->foreign('harga_kusus_id')->references('id')->on('harga_kusus')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pembelian', function(Blueprint $table) {
			$table->foreign('barang_id')->references('id')->on('barang')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('barang', function(Blueprint $table) {
			$table->dropForeign('barang_satuan_id_foreign');
		});
		Schema::table('penjualan', function(Blueprint $table) {
			$table->dropForeign('penjualan_barang_id_foreign');
		});
		Schema::table('penjualan', function(Blueprint $table) {
			$table->dropForeign('penjualan_harga_kusus_id_foreign');
		});
		Schema::table('pembelian', function(Blueprint $table) {
			$table->dropForeign('pembelian_barang_id_foreign');
		});
	}
}